<?php
if (!isset($pageTitle)) {
    $pageTitle = 'Admin';
}
if (!isset($currentUser)) {
    $currentUser = null;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($pageTitle); ?> | Admin</title>
    <link rel="stylesheet" href="../app/assets/css/style.css">
</head>
<body>
<div class="app-shell">
    <aside class="sidebar">
        <div class="sidebar-logo">
            <div class="sidebar-logo-badge">AD</div>
            <div>
                <div>Task Admin</div>
                <small style="font-size:11px;color:rgba(148,163,184,0.9)">Control center</small>
            </div>
        </div>
        <nav class="sidebar-nav">
            <a href="dashboard.php" class="sidebar-link active">
                <span class="icon">📊</span>
                <span>Overview</span>
            </a>
            <a href="users.php" class="sidebar-link">
                <span class="icon">👥</span>
                <span>Users</span>
            </a>
            <a href="tasks.php" class="sidebar-link">
                <span class="icon">📝</span>
                <span>Tasks</span>
            </a>
            <a href="payouts.php" class="sidebar-link">
                <span class="icon">💸</span>
                <span>Payouts</span>
            </a>
            <a href="settings.php" class="sidebar-link">
                <span class="icon">⚙</span>
                <span>Settings</span>
            </a>
        </nav>
    </aside>
    <div class="main-area">
        <header class="app-header">
            <div class="header-left">
                <h2><?php echo htmlspecialchars($pageTitle); ?></h2>
                <span>Administrative control of the task economy</span>
            </div>
            <div class="header-right">
                <div class="theme-toggle" data-theme-toggle>
                    <span class="sun">☀</span>
                    <span class="moon">🌙</span>
                    <div class="theme-toggle-thumb"></div>
                </div>
                <div class="avatar-pill">
                    <div class="avatar-circle">
                        <?php
                        $initials = 'A';
                        if ($currentUser && isset($currentUser['name'])) {
                            $parts = preg_split('/\s+/', trim($currentUser['name']));
                            if ($parts && $parts[0] !== '') {
                                $initials = strtoupper(mb_substr($parts[0], 0, 1, 'UTF-8'));
                            }
                        }
                        echo htmlspecialchars($initials);
                        ?>
                    </div>
                    <span><?php echo $currentUser ? htmlspecialchars($currentUser['name']) : 'Admin'; ?></span>
                </div>
            </div>
        </header>
        <main class="main-content">

