<?php
require_once __DIR__ . '/../app/includes/auth_check.php';

require_admin();
$currentUser = current_user();
$pageTitle = 'Overview';
$db = db_connection();

$totals = [
    'users' => 0,
    'tasks' => 0,
    'pending_payouts' => 0,
    'total_earnings' => 0,
];

$res = $db->query('SELECT COUNT(*) AS c FROM users');
if ($res) {
    $totals['users'] = (int)$res->fetch_assoc()['c'];
}

$res = $db->query('SELECT COUNT(*) AS c FROM tasks WHERE status = "active"');
if ($res) {
    $totals['tasks'] = (int)$res->fetch_assoc()['c'];
}

$res = $db->query('SELECT COALESCE(SUM(amount),0) AS total FROM payouts WHERE status = "pending"');
if ($res) {
    $totals['pending_payouts'] = (float)$res->fetch_assoc()['total'];
}

$res = $db->query('SELECT COALESCE(SUM(earning_amount),0) AS total FROM user_tasks WHERE status = "approved"');
if ($res) {
    $totals['total_earnings'] = (float)$res->fetch_assoc()['total'];
}

$recentUsers = [];
$res = $db->query('SELECT name, email, role, created_at FROM users ORDER BY created_at DESC LIMIT 5');
if ($res) {
    $recentUsers = $res->fetch_all(MYSQLI_ASSOC);
}

$recentPayouts = [];
$res = $db->query('SELECT p.amount, p.status, p.requested_at, u.email FROM payouts p JOIN users u ON u.id = p.user_id ORDER BY p.requested_at DESC LIMIT 5');
if ($res) {
    $recentPayouts = $res->fetch_all(MYSQLI_ASSOC);
}

include __DIR__ . '/admin_header.php';
?>
    <section class="card">
        <div class="card-header">
            <div>
                <h3>Platform pulse</h3>
                <span>Live overview of users, tasks and payouts</span>
            </div>
        </div>
        <div class="tasks-grid">
            <div class="task-card">
                <div class="task-title">Total users</div>
                <div class="task-meta-row">
                    <span>Registered accounts</span>
                    <span class="task-amount"><?php echo $totals['users']; ?></span>
                </div>
            </div>
            <div class="task-card">
                <div class="task-title">Active tasks</div>
                <div class="task-meta-row">
                    <span>Visible to users</span>
                    <span class="task-amount"><?php echo $totals['tasks']; ?></span>
                </div>
            </div>
            <div class="task-card">
                <div class="task-title">Pending payouts</div>
                <div class="task-meta-row">
                    <span>Waiting approval</span>
                    <span class="task-amount">$<?php echo number_format($totals['pending_payouts'], 2); ?></span>
                </div>
            </div>
            <div class="task-card">
                <div class="task-title">Total earnings</div>
                <div class="task-meta-row">
                    <span>Approved for users</span>
                    <span class="task-amount">$<?php echo number_format($totals['total_earnings'], 2); ?></span>
                </div>
            </div>
        </div>
    </section>
    <section class="card card-subtle">
        <div class="card-header">
            <div>
                <h3>Recent users</h3>
                <span>Latest registrations</span>
            </div>
        </div>
        <table class="table-simple">
            <thead>
            <tr>
                <th>Name</th>
                <th>Email</th>
                <th>Role</th>
                <th>Joined</th>
            </tr>
            </thead>
            <tbody>
            <?php if (!$recentUsers): ?>
                <tr>
                    <td colspan="4" style="font-size:12px;color:var(--text-muted)">No users yet.</td>
                </tr>
            <?php else: ?>
                <?php foreach ($recentUsers as $u): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($u['name']); ?></td>
                        <td><?php echo htmlspecialchars($u['email']); ?></td>
                        <td><?php echo htmlspecialchars($u['role']); ?></td>
                        <td><?php echo htmlspecialchars($u['created_at']); ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
            </tbody>
        </table>
    </section>
    <section class="card card-subtle">
        <div class="card-header">
            <div>
                <h3>Recent payouts</h3>
                <span>Latest withdrawal requests</span>
            </div>
        </div>
        <table class="table-simple">
            <thead>
            <tr>
                <th>User</th>
                <th>Amount</th>
                <th>Status</th>
                <th>Requested</th>
            </tr>
            </thead>
            <tbody>
            <?php if (!$recentPayouts): ?>
                <tr>
                    <td colspan="4" style="font-size:12px;color:var(--text-muted)">No payouts yet.</td>
                </tr>
            <?php else: ?>
                <?php foreach ($recentPayouts as $p): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($p['email']); ?></td>
                        <td>$<?php echo number_format($p['amount'], 2); ?></td>
                        <td>
                            <?php
                            $badgeClass = 'badge-neutral';
                            if ($p['status'] === 'paid') {
                                $badgeClass = 'badge-success';
                            } elseif ($p['status'] === 'pending') {
                                $badgeClass = 'badge-warning';
                            }
                            ?>
                            <span class="badge <?php echo $badgeClass; ?>"><?php echo htmlspecialchars($p['status']); ?></span>
                        </td>
                        <td><?php echo htmlspecialchars($p['requested_at']); ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
            </tbody>
        </table>
    </section>
<?php
include __DIR__ . '/admin_footer.php';
