<?php
require_once __DIR__ . '/../app/includes/auth_check.php';

require_admin();
$currentUser = current_user();
$pageTitle = 'Payouts';
$db = db_connection();

if (empty($_SESSION['csrf_token_admin_payouts'])) {
    $_SESSION['csrf_token_admin_payouts'] = bin2hex(random_bytes(16));
}

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $token = $_POST['csrf_token'] ?? '';
    if (hash_equals($_SESSION['csrf_token_admin_payouts'], $token)) {
        $payoutId = (int)($_POST['payout_id'] ?? 0);
        $action = $_POST['action'] ?? '';
        if ($payoutId > 0 && in_array($action, ['mark_paid', 'mark_failed'], true)) {
            if ($action === 'mark_paid') {
                $stmt = $db->prepare('UPDATE payouts SET status = "paid", paid_at = NOW() WHERE id = ?');
            } else {
                $stmt = $db->prepare('UPDATE payouts SET status = "failed" WHERE id = ?');
            }
            $stmt->bind_param('i', $payoutId);
            $stmt->execute();
            $stmt->close();
            $message = 'Payout updated.';
        }
    }
}

$res = $db->query('SELECT p.id, p.user_id, p.amount, p.status, p.requested_at, p.paid_at, u.email FROM payouts p JOIN users u ON u.id = p.user_id ORDER BY p.requested_at DESC');
$payouts = $res ? $res->fetch_all(MYSQLI_ASSOC) : [];

include __DIR__ . '/admin_header.php';
?>
    <section class="card">
        <div class="card-header">
            <div>
                <h3>Manage payouts</h3>
                <span>Review and approve withdrawal requests</span>
            </div>
        </div>
        <?php if ($message !== ''): ?>
            <div class="alert" style="background:rgba(34,197,94,0.12);border:1px solid rgba(34,197,94,0.6);color:#166534">
                <?php echo htmlspecialchars($message); ?>
            </div>
        <?php endif; ?>
        <table class="table-simple">
            <thead>
            <tr>
                <th>User</th>
                <th>Amount</th>
                <th>Status</th>
                <th>Requested</th>
                <th>Paid</th>
                <th>Actions</th>
            </tr>
            </thead>
            <tbody>
            <?php if (!$payouts): ?>
                <tr>
                    <td colspan="6" style="font-size:12px;color:var(--text-muted)">No payout requests.</td>
                </tr>
            <?php else: ?>
                <?php foreach ($payouts as $p): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($p['email']); ?></td>
                        <td>$<?php echo number_format($p['amount'], 2); ?></td>
                        <td><?php echo htmlspecialchars($p['status']); ?></td>
                        <td><?php echo htmlspecialchars($p['requested_at']); ?></td>
                        <td><?php echo htmlspecialchars($p['paid_at'] ?: '-'); ?></td>
                        <td>
                            <?php if ($p['status'] === 'pending'): ?>
                                <form method="post" style="display:inline-flex;gap:4px;align-items:center">
                                    <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($_SESSION['csrf_token_admin_payouts']); ?>">
                                    <input type="hidden" name="payout_id" value="<?php echo (int)$p['id']; ?>">
                                    <button type="submit" name="action" value="mark_paid" style="font-size:11px;border-radius:999px;padding:4px 9px;border:none;background:rgba(22,163,74,0.15);color:#15803d;cursor:pointer">
                                        Mark paid
                                    </button>
                                    <button type="submit" name="action" value="mark_failed" style="font-size:11px;border-radius:999px;padding:4px 9px;border:none;background:rgba(248,113,113,0.15);color:#b91c1c;cursor:pointer">
                                        Mark failed
                                    </button>
                                </form>
                            <?php else: ?>
                                <span style="font-size:11px;color:var(--text-muted)">No actions</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
            </tbody>
        </table>
    </section>
<?php
include __DIR__ . '/admin_footer.php';
