<?php
require_once __DIR__ . '/../app/includes/auth_check.php';

require_admin();
$currentUser = current_user();
$pageTitle = 'Settings';
$db = db_connection();

if (empty($_SESSION['csrf_token_admin_settings'])) {
    $_SESSION['csrf_token_admin_settings'] = bin2hex(random_bytes(16));
}

$message = '';

function get_setting($key, $default = '')
{
    $db = db_connection();
    $stmt = $db->prepare('SELECT setting_value FROM site_settings WHERE setting_key = ? LIMIT 1');
    $stmt->bind_param('s', $key);
    $stmt->execute();
    $res = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    if ($res && isset($res['setting_value'])) {
        return $res['setting_value'];
    }
    return $default;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $token = $_POST['csrf_token'] ?? '';
    if (hash_equals($_SESSION['csrf_token_admin_settings'], $token)) {
        $siteName = trim($_POST['site_name'] ?? '');
        $goal = trim($_POST['monthly_goal'] ?? '');
        $currency = trim($_POST['currency'] ?? '');

        $stmt = $db->prepare("INSERT INTO site_settings (setting_key, setting_value) VALUES 
            ('site_name', ?),
            ('monthly_goal', ?),
            ('currency', ?)
            ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value)");
        $stmt->bind_param('sss', $siteName, $goal, $currency);
        $stmt->execute();
        $stmt->close();
        $message = 'Settings saved.';
    }
}

$currentSiteName = get_setting('site_name', 'Task Dashboard');
$currentGoal = get_setting('monthly_goal', '5000');
$currentCurrency = get_setting('currency', 'USD');

include __DIR__ . '/admin_header.php';
?>
    <section class="card">
        <div class="card-header">
            <div>
                <h3>Platform settings</h3>
                <span>Brand and financial defaults</span>
            </div>
        </div>
        <?php if ($message !== ''): ?>
            <div class="alert" style="background:rgba(34,197,94,0.12);border:1px solid rgba(34,197,94,0.6);color:#166534">
                <?php echo htmlspecialchars($message); ?>
            </div>
        <?php endif; ?>
        <form method="post" style="max-width:420px">
            <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($_SESSION['csrf_token_admin_settings']); ?>">
            <div class="form-group">
                <label for="site_name">Site name</label>
                <input type="text" id="site_name" name="site_name" value="<?php echo htmlspecialchars($currentSiteName); ?>" required>
            </div>
            <div class="form-group">
                <label for="monthly_goal">Monthly goal amount</label>
                <input type="number" id="monthly_goal" name="monthly_goal" value="<?php echo htmlspecialchars($currentGoal); ?>" required>
            </div>
            <div class="form-group">
                <label for="currency">Currency code</label>
                <input type="text" id="currency" name="currency" value="<?php echo htmlspecialchars($currentCurrency); ?>" required>
            </div>
            <button type="submit" class="btn-primary" style="width:auto;padding-inline:18px">Save settings</button>
        </form>
    </section>
<?php
include __DIR__ . '/admin_footer.php';
