document.addEventListener('DOMContentLoaded', function () {
    var root = document.documentElement;
    var themeToggle = document.querySelector('[data-theme-toggle]');
    var stored = localStorage.getItem('task_dashboard_theme');

    if (stored === 'dark') {
        root.classList.add('dark-theme');
    }

    if (themeToggle) {
        themeToggle.addEventListener('click', function () {
            var isDark = root.classList.toggle('dark-theme');
            localStorage.setItem('task_dashboard_theme', isDark ? 'dark' : 'light');
        });
    }
});

