<?php
session_start();

$configPath = __DIR__ . '/../config/config.php';
$lockPath = __DIR__ . '/../config/install.lock';

if (!file_exists($configPath) || !file_exists($lockPath)) {
    header('Location: ../../install.php');
    exit;
}

require_once $configPath;

$pageTitle = 'Dashboard';
$currentUser = null;

$db = db_connection();

if (isset($_SESSION['user_id'])) {
    $stmt = $db->prepare('SELECT id, name, email, role FROM users WHERE id = ? LIMIT 1');
    $stmt->bind_param('i', $_SESSION['user_id']);
    $stmt->execute();
    $result = $stmt->get_result();
    $currentUser = $result->fetch_assoc() ?: null;
    $stmt->close();
}

$totalEarnings = 0;
$goal = 5000;
$activeTasks = 0;
$completedTasks = 0;
$pendingPayout = 0;

if ($currentUser) {
    $stmt = $db->prepare('SELECT COALESCE(SUM(earning_amount),0) AS total FROM user_tasks WHERE user_id = ? AND status = "approved"');
    $stmt->bind_param('i', $_SESSION['user_id']);
    $stmt->execute();
    $result = $stmt->get_result()->fetch_assoc();
    $totalEarnings = (float)($result['total'] ?? 0);
    $stmt->close();

    $stmt = $db->prepare('SELECT COUNT(*) AS c FROM user_tasks WHERE user_id = ? AND status IN ("assigned","in_progress","submitted")');
    $stmt->bind_param('i', $_SESSION['user_id']);
    $stmt->execute();
    $result = $stmt->get_result()->fetch_assoc();
    $activeTasks = (int)($result['c'] ?? 0);
    $stmt->close();

    $stmt = $db->prepare('SELECT COUNT(*) AS c FROM user_tasks WHERE user_id = ? AND status IN ("approved","rejected")');
    $stmt->bind_param('i', $_SESSION['user_id']);
    $stmt->execute();
    $result = $stmt->get_result()->fetch_assoc();
    $completedTasks = (int)($result['c'] ?? 0);
    $stmt->close();

    $stmt = $db->prepare('SELECT COALESCE(SUM(amount),0) AS total FROM payouts WHERE user_id = ? AND status = "pending"');
    $stmt->bind_param('i', $_SESSION['user_id']);
    $stmt->execute();
    $result = $stmt->get_result()->fetch_assoc();
    $pendingPayout = (float)($result['total'] ?? 0);
    $stmt->close();
} else {
    $res = $db->query('SELECT COALESCE(SUM(earning_amount),0) AS total FROM user_tasks WHERE status = "approved"');
    if ($res) {
        $row = $res->fetch_assoc();
        $totalEarnings = (float)($row['total'] ?? 0);
    }
    $res = $db->query('SELECT COUNT(*) AS c FROM tasks WHERE status = "active"');
    if ($res) {
        $row = $res->fetch_assoc();
        $activeTasks = (int)($row['c'] ?? 0);
    }
    $completedTasks = 0;
    $pendingPayout = 0;
}

$percent = $goal > 0 ? min(100, round(($totalEarnings / $goal) * 100)) : 0;

$tasks = [];
$stmt = $db->prepare('SELECT id, title, reward_amount, status FROM tasks WHERE status = "active" ORDER BY created_at DESC LIMIT 4');
$stmt->execute();
$res = $stmt->get_result();
while ($row = $res->fetch_assoc()) {
    $tasks[] = $row;
}
$stmt->close();

include __DIR__ . '/../includes/header.php';
?>
    <section class="card">
        <div class="card-header">
            <div>
                <h3>Total Earnings</h3>
                <span>Live overview of your task income</span>
            </div>
            <div class="tag-pill">
                <span class="tag-dot"></span>
                <span><?php echo $percent; ?>% of monthly goal</span>
            </div>
        </div>
        <div class="earnings-circle-wrap">
            <div class="earnings-circle">
                <div class="earnings-circle-inner">
                    <span style="font-size:11px;color:var(--text-muted)">This month</span>
                    <h2>$<?php echo number_format($totalEarnings, 2); ?></h2>
                    <span>Goal $<?php echo number_format($goal, 0); ?></span>
                </div>
                <span class="earnings-badge">Position now awarded</span>
            </div>
            <div class="earnings-meta">
                <div class="meta-row">
                    <span class="label">Active tasks</span>
                    <span class="value"><?php echo $activeTasks; ?></span>
                </div>
                <div class="meta-row">
                    <span class="label">Completed tasks</span>
                    <span class="value"><?php echo $completedTasks; ?></span>
                </div>
                <div class="meta-row">
                    <span class="label">Pending payout</span>
                    <span class="value">$<?php echo number_format($pendingPayout, 2); ?></span>
                </div>
                <div class="meta-row">
                    <span class="label">Goal progress</span>
                    <span class="value"><?php echo $percent; ?>%</span>
                </div>
            </div>
        </div>
    </section>
    <section class="card card-subtle">
        <div class="card-header">
            <div>
                <h3>Available tasks</h3>
                <span>Curated tasks ready to start</span>
            </div>
            <span style="font-size:12px;color:var(--text-muted)">Today</span>
        </div>
        <div class="tasks-grid">
            <?php if (!$tasks): ?>
                <div style="font-size:12px;color:var(--text-muted)">No active tasks yet. Please check back later.</div>
            <?php else: ?>
                <?php foreach ($tasks as $task): ?>
                    <article class="task-card">
                        <div class="task-title"><?php echo htmlspecialchars($task['title']); ?></div>
                        <div class="task-meta-row">
                            <span><?php echo $task['status'] === 'active' ? 'Available' : htmlspecialchars($task['status']); ?></span>
                            <span class="task-amount">$<?php echo number_format($task['reward_amount'], 2); ?></span>
                        </div>
                        <button class="task-cta" type="button">View task</button>
                    </article>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </section>
    <section class="card card-subtle">
        <div class="card-header">
            <div>
                <h3>Today snapshot</h3>
                <span>Quick stats of your activity</span>
            </div>
        </div>
        <div class="stats-list">
            <div class="stats-item">
                <span class="stats-label">Tasks completed today</span>
                <span class="stats-value"><?php echo $completedTasks; ?></span>
            </div>
            <div class="stats-item">
                <span class="stats-label">Earnings today</span>
                <span class="stats-value">$<?php echo number_format($totalEarnings, 2); ?></span>
            </div>
            <div class="stats-item">
                <span class="stats-label">Average reward per task</span>
                <span class="stats-value">
                    <?php
                    if ($completedTasks > 0 && $totalEarnings > 0) {
                        echo '$' . number_format($totalEarnings / $completedTasks, 2);
                    } else {
                        echo '$0.00';
                    }
                    ?>
                </span>
            </div>
        </div>
    </section>
<?php
include __DIR__ . '/../includes/footer.php';
