<?php
require_once __DIR__ . '/../includes/auth_check.php';

$currentUser = current_user();
$pageTitle = 'Tasks';
$db = db_connection();

$stmt = $db->prepare('SELECT t.id, t.title, t.reward_amount, t.status, ut.status AS user_status FROM tasks t LEFT JOIN user_tasks ut ON ut.task_id = t.id AND ut.user_id = ? ORDER BY t.created_at DESC');
$stmt->bind_param('i', $_SESSION['user_id']);
$stmt->execute();
$tasks = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt->close();

include __DIR__ . '/../includes/header.php';
?>
    <section class="card">
        <div class="card-header">
            <div>
                <h3>All tasks</h3>
                <span>Browse and pick a task to earn</span>
            </div>
        </div>
        <table class="table-simple">
            <thead>
            <tr>
                <th>Title</th>
                <th>Reward</th>
                <th>Status</th>
                <th>Your state</th>
            </tr>
            </thead>
            <tbody>
            <?php if (!$tasks): ?>
                <tr>
                    <td colspan="4" style="font-size:12px;color:var(--text-muted)">No tasks available yet.</td>
                </tr>
            <?php else: ?>
                <?php foreach ($tasks as $task): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($task['title']); ?></td>
                        <td>$<?php echo number_format($task['reward_amount'], 2); ?></td>
                        <td>
                            <?php
                            $badgeClass = 'badge-neutral';
                            if ($task['status'] === 'active') {
                                $badgeClass = 'badge-success';
                            } elseif ($task['status'] === 'inactive') {
                                $badgeClass = 'badge-warning';
                            }
                            ?>
                            <span class="badge <?php echo $badgeClass; ?>"><?php echo htmlspecialchars($task['status']); ?></span>
                        </td>
                        <td><?php echo $task['user_status'] ? htmlspecialchars($task['user_status']) : 'Not started'; ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
            </tbody>
        </table>
    </section>
<?php
include __DIR__ . '/../includes/footer.php';
