<?php
require_once __DIR__ . '/../includes/auth_check.php';

$currentUser = current_user();
$pageTitle = 'Wallet';
$db = db_connection();

$stmt = $db->prepare('SELECT COALESCE(SUM(earning_amount),0) AS total FROM user_tasks WHERE user_id = ? AND status = "approved"');
$stmt->bind_param('i', $_SESSION['user_id']);
$stmt->execute();
$totalEarnings = (float)($stmt->get_result()->fetch_assoc()['total'] ?? 0);
$stmt->close();

$stmt = $db->prepare('SELECT COALESCE(SUM(amount),0) AS total FROM payouts WHERE user_id = ? AND status = "paid"');
$stmt->bind_param('i', $_SESSION['user_id']);
$stmt->execute();
$totalPaid = (float)($stmt->get_result()->fetch_assoc()['total'] ?? 0);
$stmt->close();

$availableBalance = $totalEarnings - $totalPaid;

include __DIR__ . '/../includes/header.php';
?>
    <section class="card">
        <div class="card-header">
            <div>
                <h3>Your wallet</h3>
                <span>Overview of your earnings and payouts</span>
            </div>
        </div>
        <div class="stats-list">
            <div class="stats-item">
                <span class="stats-label">Total earnings</span>
                <span class="stats-value">$<?php echo number_format($totalEarnings, 2); ?></span>
            </div>
            <div class="stats-item">
                <span class="stats-label">Total paid out</span>
                <span class="stats-value">$<?php echo number_format($totalPaid, 2); ?></span>
            </div>
            <div class="stats-item">
                <span class="stats-label">Available balance</span>
                <span class="stats-value">$<?php echo number_format($availableBalance, 2); ?></span>
            </div>
        </div>
    </section>
<?php
include __DIR__ . '/../includes/footer.php';
